<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('category_id', 'name', 'price', 'status', 'description', 'quantity_order', 'dimension', 'store_id');

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function tags()
    {
        return $this->hasMany('App\Models\Tag');
    }

    public function rate()
    {
        return $this->hasMany('App\Models\ProductRate');
    }

}